package eqsolver.ui;

import java.awt.GridLayout;
import java.util.Observable;
import java.util.Observer;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

import eqsolver.ProxyEquation;
import eqsolver.ViewLinearEquation;
import eqsolver.ViewQuadraticEquation;

public class EquationPanel extends JPanel implements Observer {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JLabel paramLabel = new JLabel("bla");
	private JLabel formulaLabel = new JLabel("bla");
	private ProxyEquation equation;
	
	public EquationPanel(ProxyEquation equation) {
		this.equation = equation;
		equation.addObserver(this);
		
		setBorder(BorderFactory.createEtchedBorder());
		setLayout(new GridLayout(3, 1));
		JLabel infoLabel = new JLabel("Equazioni");
		add(infoLabel);
		add(formulaLabel);
		add(paramLabel);
	}
	
	public void update(Observable arg0, Object arg1) {
//		formulaLabel.setText(((Integer) equation.getNumberParam()).toString());
//		paramLabel.setText("paramx^2 etc");
		switch (equation.getNumberParam()) {
		case 1:
			formulaLabel.setText((new ViewLinearEquation(equation)).getFormula());
			paramLabel.setText((new ViewLinearEquation(equation)).getParamFormula());
			break;

		case 2:
			formulaLabel.setText((new ViewLinearEquation(equation)).getFormula());
			paramLabel.setText((new ViewLinearEquation(equation)).getParamFormula());
			break;
		case 3:
			formulaLabel.setText((new ViewQuadraticEquation(equation)).getFormula());
			paramLabel.setText((new ViewQuadraticEquation(equation)).getParamFormula());
			break;
			
		default:
			paramLabel.setText("errore orribile");
			break;
		}
		
	}

}
